<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Question;
use App\Models\Category;
use App\Models\Station;
use App\Models\Feedback;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        $feedback = Feedback::all();
        $selectedCategory = $request->input('category');

        // Retrieve all questions or filter by category if selected
        $query = Question::query();
        if ($selectedCategory) {
            $query->where('category_id', $selectedCategory);
        }
        $questions = $query->get();
    
        // Retrieve all categories for the filter dropdown
        $categories = Category::all();
    
        if ($request->expectsJson()) {
            return view('questions._questions_table', compact('questions'));
        }
    
        return view('home', compact('categories', 'questions', 'feedback'));
    }
    
}
