<?php

namespace App\Http\Controllers;
use Illuminate\Validation\Rule;
use App\Models\User;
use App\Models\Category;
use App\Models\Question;
use App\Models\Feedback;
use App\Models\Station;

use Illuminate\Http\Request;

class QuestionsController extends Controller
{

    public function user()
    {
        $stations = Station::all();

        return view('welcome', compact('stations'));
    }

    public function choose()
    {
        return view('questions.choose');
    }

    public function index(Request $request)
{
    $selectedCategory = $request->input('category');

    // Retrieve all questions or filter by category if selected
    $query = Question::query();
    if ($selectedCategory) {
        $query->where('category_id', $selectedCategory);
    }
    $questions = $query->get();

    // Retrieve all categories for the filter dropdown
    $categories = Category::all();

    return view('questions.index', compact('questions', 'categories', 'selectedCategory'));
}
    public function create()
    {
        $categories = Category::all();
        return view('questions.create', compact('categories'));
    }
    public function createFeedback()
    {
       
        return view('questions.feedback');
    }
    public function storeUser(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'station_id' => 'required',
        ]);

        $user = User::where('email', $request->email)->first();

        if ($user) {
            // If the email is already taken, store the user details in the session and redirect
            session(['user_id' => $user->id, 'user_email' => $user->email]);
            return redirect('/choose');
        }

        $user = User::create($request->only(['name', 'email', 'station_id']));

        // Store the user details in the session
        session(['user_id' => $user->id, 'user_email' => $user->email]);

        return redirect('/choose');

    }
    public function store(Request $request)
    {
        $request->validate([
            'category_id' => 'required',
            'question' => 'required',
        ]);

        $userId = $request->session()->get('user_id');
        $questionData = $request->except('_token');
        $questionData['user_id'] = $userId;

        $question = Question::create($questionData);

        return redirect('/choose')->with('success', 'Question submitted successfully.');
    }
    public function storeFeedback(Request $request)
    {
        $request->validate([
            'overall_assessment' => 'required',
            'workshop_objectives_rating' => 'required|integer|min:1|max:10',
            'most_interesting_aspect' => 'required',
            'liked_most' => 'required',
            'liked_least' => 'required',
            'improvement_suggestions' => 'required|string',
            'content_agenda_rating' => 'required|string',
            'materials_handouts_rating' => 'required|string',
            'consultants_rating' => 'required|string',
            'workshop_length_rating' => 'required|string',
            'logistical_arrangements_rating' => 'required|string',
            'venue_rating' => 'required|string',
            'lunches_tea_breaks_rating' => 'required|string',
            'improvement_suggestions_workshop' => 'required|string',
            'other_comments' => 'nullable|string',
        ]);

        
       
        // Create a new feedback instance and fill it with the validated data
        $feedback = new Feedback();
        $feedback->user_id = $request->session()->get('user_id');
        $feedback->overall_assessment = $request->input('overall_assessment');
        $feedback->workshop_objectives_rating = (int) $request->input('workshop_objectives_rating');
        $feedback->workshop_objectives_rating = $request->input('workshop_objectives_rating');
        $feedback->most_interesting_aspect = $request->input('most_interesting_aspect');
        $feedback->liked_most = $request->input('liked_most');
        $feedback->liked_least = $request->input('liked_least');
        $feedback->improvement_suggestions = $request->input('improvement_suggestions');
        $feedback->content_agenda_rating = $request->input('content_agenda_rating');
        $feedback->materials_handouts_rating = $request->input('materials_handouts_rating');
        $feedback->consultants_rating = $request->input('consultants_rating');
        $feedback->workshop_length_rating = $request->input('workshop_length_rating');
        $feedback->logistical_arrangements_rating = $request->input('logistical_arrangements_rating');
        $feedback->venue_rating = $request->input('venue_rating');
        $feedback->lunches_tea_breaks_rating = $request->input('lunches_tea_breaks_rating');
        $feedback->improvement_suggestions_workshop = $request->input('improvement_suggestions_workshop');
        $feedback->other_comments = $request->input('other_comments');
        
        // Save the feedback to the database
        $feedback->save();

        
        return redirect('/')->with('success', 'Thank you for your feedback!');
        
    }

    public function edit($id)
{
    $question = Question::findOrFail($id);
    
    return view('questions.edit', compact('question'));
}

public function update(Request $request, $id)
{
    $question = Question::findOrFail($id);
   
    $question->update($request->all());

    
    return redirect()->back()->with('success', 'Question updated successfully.');
}

public function destroy($id)
{
    $question = Question::findOrFail($id);
    $question->delete();

    return redirect()->back()->with('success', 'Question deleted successfully.');
}

}