<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('feedback', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->text('overall_assessment')->nullable();
            $table->integer('workshop_objectives_rating')->nullable();
            $table->text('most_interesting_aspect')->nullable();
            $table->text('liked_most')->nullable();
            $table->text('liked_least')->nullable();
            $table->text('improvement_suggestions')->nullable();
            $table->string('content_agenda_rating')->nullable();
            $table->string('materials_handouts_rating')->nullable();
            $table->string('consultants_rating')->nullable();
            $table->string('workshop_length_rating')->nullable();
            $table->string('logistical_arrangements_rating')->nullable();
            $table->string('venue_rating')->nullable();
            $table->string('lunches_tea_breaks_rating')->nullable();
            $table->text('improvement_suggestions_workshop')->nullable();
            $table->text('other_comments')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('feedback');
    }
};
