@extends('layouts.admin')

@section('content')
<div class="row">  
  @if (session('success'))
    <div class="alert alert-success" role="alert">
      {{ session('success') }}
    </div>
  @endif
</div>
    <ul class="nav nav-tabs nav-tabs-bordered">
        <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#polls">Live Polls</button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#audience">Audience Q&A</button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#analytics">Feedback Analysis</button>
        </li>    
    </ul>

    <div class="tab-content pt-2">
        <div class="tab-pane fade show active pt-3" id="polls">
            <div class="card">
                <div class="card-header">
                    Live Polls
                </div>
                <div class="card-body">
                    <div id="live-polls"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="tab-content pt-2">
        <div class="tab-pane fade pt-3" id="audience">
            <div class="card">
                <div class="card-header">
                    Questions
                </div>
                <div class="card-body">
                    <form id="filter-form">
                        <div class="mb-3">
                            <label for="category-select" class="form-label">Category:</label>
                            <select id="category-select" name="category" class="form-select">
                                <option value="">All</option>
                                @foreach ($categories as $category)
                                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary">Filter</button>
                        
                    </form>
                    <div class="col-md-12 table-responsive">
                    <table class="table table-responsive">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Name</th>
                                <th scope="col">Station</th>
                                <th scope="col">Category</th>
                                <th scope="col">Question</th>
                                <th scope="col">Action</th>

                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($questions as $question)
                                <tr>
                                    <th scope="row"></th>
                                    <td>{{ $question->user->name }}</td>
                                    <td>{{ $question->user->station->name }}</td>
                                    <td>{{ $question->category->name }}</td>
                                    <td>{{ $question->question }}</td>
                                    <td>
                                      <a href="{{ route('questions.edit', $question->id) }}" class="btn btn-primary"><i class="fas fa-edit"></i></a>
                                      <form action="{{ route('questions.destroy', $question->id) }}" method="POST" style="display: inline-block;">
                                          @csrf
                                          @method('DELETE')
                                          <button type="submit" class="btn btn-danger"> <i class="fas fa-trash"></i></button>
                                      </form>                                        
                                        
                                        
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="tab-content pt-2">
        <div class="tab-pane fade pt-3" id="analytics">
            <div class="card">
                <div class="card-header">
                    Analytics
                </div>
                <div class="card-body">
                         <!-- Sales Card -->
                  <div class="row">
                    
                          <!-- Left side columns -->
                          <div class="col-lg-8">
                            <div class="row">
                  
                              <!-- Sales Card -->
                              <div class="col-xxl-4 col-md-6">
                                <div class="card info-card sales-card">                  
                                  
                                  <div class="card-body">
                                    <h5 class="card-title">Feedback<span>| Total</span></h5>
                  
                                    <div class="d-flex align-items-center">
                                      <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                        <i class="bi bi-chat"></i>
                                      </div>
                                      <div class="ps-3">
                                        
                                        <span class="text-success small pt-1 fw-bold">1</span>
                  
                                      </div>
                                    </div>
                                  </div>
                  
                                </div>
                              </div><!-- End Sales Card -->
                  
                              <!-- Revenue Card -->
                              <div class="col-xxl-4 col-md-6">
                                <div class="card info-card revenue-card">
                  
                                  
                  
                                  <div class="card-body">
                                    <h5 class="card-title">Objectives Rating <span>| Average</span></h5>
                  
                                    <div class="d-flex align-items-center">
                                      <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                        <i class="bi bi-star-half"></i>
                                      </div>
                                      <div class="ps-3">
                                       
                                        <span class="text-success small pt-1 fw-bold">8</span> 
                  
                                      </div>
                                    </div>
                                  </div>
                  
                                </div>
                              </div><!-- End Revenue Card -->
                  
                              <!-- Customers Card -->
                              <div class="col-xxl-4 col-xl-12">
                  
                                <div class="card info-card customers-card">
                  
                                                    
                                  <div class="card-body">
                                    <h5 class="card-title">Dealers <span>| This Year</span></h5>
                  
                                    <div class="d-flex align-items-center">
                                      <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                        <i class="bi bi-people"></i>
                                      </div>
                                      <div class="ps-3">
                                        <h6>124</h6>
                                        <span class="text-danger small pt-1 fw-bold">12%</span> <span class="text-muted small pt-2 ps-1">decrease</span>
                  
                                      </div>
                                    </div>
                  
                                  </div>
                                </div>
                  
                              </div><!-- End Customers Card -->
                  
                              <!-- Reports -->
                              <div class="col-12">
                                <div class="card">
                  
                                  <div class="filter">
                                    <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
                                    <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                      <li class="dropdown-header text-start">
                                        <h6>Filter</h6>
                                      </li>
                  
                                      <li><a class="dropdown-item" href="#">Today</a></li>
                                      <li><a class="dropdown-item" href="#">This Month</a></li>
                                      <li><a class="dropdown-item" href="#">This Year</a></li>
                                    </ul>
                                  </div>
                  
                                  <div class="card-body">
                                    <h5 class="card-title">Feedback <span>/Today</span></h5>
                  
                                    <!-- Line Chart -->
                                    <div id="reportsChart"></div>
                  
                                    <script>
                                      document.addEventListener("DOMContentLoaded", () => {
                                        new ApexCharts(document.querySelector("#reportsChart"), {
                                          series: [{
                                            name: 'Sales',
                                            data: [31, 40, 28, 51, 42, 82, 56],
                                          }, {
                                            name: 'Revenue',
                                            data: [11, 32, 45, 32, 34, 52, 41]
                                          }, {
                                            name: 'Customers',
                                            data: [15, 11, 32, 18, 9, 24, 11]
                                          }],
                                          chart: {
                                            height: 350,
                                            type: 'area',
                                            toolbar: {
                                              show: false
                                            },
                                          },
                                          markers: {
                                            size: 4
                                          },
                                          colors: ['#4154f1', '#2eca6a', '#ff771d'],
                                          fill: {
                                            type: "gradient",
                                            gradient: {
                                              shadeIntensity: 1,
                                              opacityFrom: 0.3,
                                              opacityTo: 0.4,
                                              stops: [0, 90, 100]
                                            }
                                          },
                                          dataLabels: {
                                            enabled: false
                                          },
                                          stroke: {
                                            curve: 'smooth',
                                            width: 2
                                          },
                                          xaxis: {
                                            type: 'datetime',
                                            categories: ["2018-09-19T00:00:00.000Z", "2018-09-19T01:30:00.000Z", "2018-09-19T02:30:00.000Z", "2018-09-19T03:30:00.000Z", "2018-09-19T04:30:00.000Z", "2018-09-19T05:30:00.000Z", "2018-09-19T06:30:00.000Z"]
                                          },
                                          tooltip: {
                                            x: {
                                              format: 'dd/MM/yy HH:mm'
                                            },
                                          }
                                        }).render();
                                      });
                                    </script>
                                    <!-- End Line Chart -->
                  
                                  </div>
                  
                                </div>
                              </div><!-- End Reports -->
                  
                            
                  
                            </div>
                  
                           
                          </div><!-- End Left side columns -->
                  
                          <!-- Right side columns -->
                          <div class="col-lg-4">
                  
                  
                            <!-- News & Updates Traffic -->
                            <div class="card">
                              <div class="filter">
                                <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
                                <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                  <li class="dropdown-header text-start">
                                    <h6>Filter</h6>
                                  </li>
                  
                                  <li><a class="dropdown-item" href="#">Today</a></li>
                                  <li><a class="dropdown-item" href="#">This Month</a></li>
                                  <li><a class="dropdown-item" href="#">This Year</a></li>
                                </ul>
                              </div>
                  
                              <div class="card-body pb-0">
                                <h5 class="card-title">Feedback Updates <span>| Live</span></h5>
                                <div class="news">
                                    @foreach($feedback as $item)
                                    <div class="post-item clearfix">
                                       
                                        <h4><a href="#">{{ $item->user->name }}</a></h4>
                                        <div class="row">
                                          <div class="col"><h5>Liked Most</h5></div>
                                          <div class="col">{{ $item->liked_most }}</div>
                                        </div>
                                        <div class="row">
                                          <div class="col"><h5>Least Liked</h5></div>
                                          <div class="col">{{ $item->liked_least }}</div>
                                        </div>
                                        
                                    </div>
                                    @endforeach
                                </div><!-- End sidebar recent posts-->
                            </div>
                            
                            </div><!-- End News & Updates -->
                  
                          </div><!-- End Right side columns -->
                  
                        </div>
            
  
                      </div>
  
                </div>
              </div><!-- End Reports -->
                </div>
            </div>
        </div>
    </div>
@endsection
@pushOnce('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        var filterForm = document.getElementById('filter-form');
        var questionsTable = document.getElementById('questions-table');

        filterForm.addEventListener('submit', function (event) {
            event.preventDefault();

            var formData = new FormData(filterForm);
            var xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function () {
                if (xhr.readyState === XMLHttpRequest.DONE) {
                    if (xhr.status === 200) {
                        questionsTable.innerHTML = xhr.responseText;
                    } else {
                        console.error('Request failed. Status:', xhr.status);
                    }
                }
            };
            xhr.open(filterForm.method, filterForm.action);
            xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
            xhr.send(formData);
        });
    });
</script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        var livePollsTab = document.getElementById('polls');
        var livePollsContent = document.getElementById('live-polls');

        // Load live polls content on tab activation
        livePollsTab.addEventListener('show.bs.tab', function (event) {
            if (event.target.id === 'polls') {
                loadLivePolls();
            }
        });

        // Function to load live polls content
        function loadLivePolls() {
            // Perform an AJAX request to fetch the live polls data
            var xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function () {
                if (xhr.readyState === XMLHttpRequest.DONE) {
                    if (xhr.status === 200) {
                        livePollsContent.innerHTML = xhr.responseText;
                    } else {
                        console.error('Request failed. Status:', xhr.status);
                    }
                }
            };
            xhr.open('GET', '{{ route('admin.live-polls') }}');
            xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
            xhr.send();
        }

        // Load live polls content initially
        loadLivePolls();
    });
</script>
@endPushOnce
