@extends('layouts.app')

@section('content')
<p></p>
<br>
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <h3>ASK US ANY QUESTION</h3>
                <div class="card">
                    <div class="card-header">
                        Submit Question
                    </div>
                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form method="POST" action="{{ url('/questions') }}">
                            @csrf

                            <div class="form-group">
                                <label for="category">Category</label>
                                <select class="form-control" id="category" name="category_id" required>
                                    <option value="">Select Category</option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="question">Question</label>
                                <textarea class="form-control" id="question" name="question" rows="5" required>{{ old('question') }}</textarea>
                            </div>

                            <button type="submit" class="btn btn-primary">Submit</button>
                        </form>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
