@extends('layouts.app')

@section('content')
<p></p>
<br>
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <h3>LEAVE ANONYMOUS FEEDBACK</h3>
                <div class="card">
                    <div class="card-header">
                        Submit Question
                    </div>
                    <div class="card-body">
                        

                        <div class="card">
                            <div class="card-header">
                                Feedback
                            </div>
                            <div class="card-body">
                                <form id="feedback-form" method="POST" action="{{ route('feedback.store') }}">
                                    @csrf
                                    
                                    <div class="mb-3">
                                        <label for="assessment" class="form-label">1. What is your overall assessment of the dealer seminar?</label>
                                        <textarea class="form-control @error('overall_assessment') is-invalid @enderror" id="assessment" name="overall_assessment" rows="3"></textarea>
                                    </div>
                                    <div class="mb-3">
                                        <label for="objectives-rating" class="form-label">2. To what extent were the dealer seminar objectives achieved? Please rate on a scale of 1 to 10.</label>
                                        <input type="range" class="form-range" min="1" max="10" id="workshop_objectives_rating" name="workshop_objectives_rating">
                                        <div class="d-flex justify-content-between">
                                            <span>Not at all</span>
                                            <span>Completely</span>
                                        </div>
                                    </div>                                  
                                    
                                    <div class="mb-3">
                                        <label for="interesting_aspect" class="form-label">3. Which aspect of the dealer seminar did you find the most interesting or useful?</label>
                                        <textarea class="form-control @error('most_interesting_aspect') is-invalid @enderror" id="interesting-aspect" name="most_interesting_aspect" rows="3"></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">4. What did you like most about the workshop?</label>
                                        <textarea class="form-control @error('liked_most') is-invalid @enderror" name="liked_most" rows="3" ></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">5. What did you least like about the event?</label>
                                        <textarea class="form-control @error('liked_least') is-invalid @enderror" name="liked_least" rows="3" ></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">6. How do you think the workshop could have been made more effective?</label>
                                        <textarea class="form-control @error('improvement_suggestions') is-invalid @enderror" name="improvement_suggestions" rows="3"></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">7. How would you rate the following dealer seminar components?
                                            <sup><i class='fas fa-asterisk' style='font-size:6px;color:red'></i></sup>
                                        </label>
                                        <div class="table-responsive">
                                            <table class="table">
                                        
                                            <thead>
                                                <tr>
                                                    <th>Workshop Component</th>
                                                    <th>Rating</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>Content/Agenda</td>
                                                    <td>                                                       
                                                    <select class="form-select @error('content_agenda_rating') is-invalid @enderror" name="content_agenda_rating" required>
                                                        <option value="">Choose</option>
                                                        <option value="Unsatisfactory">Unsatisfactory</option>
                                                        <option value="Poor">Poor</option>
                                                        <option value="Average">Average</option>
                                                        <option value="Good">Good</option>
                                                        <option value="Excellent">Excellent</option>
                                                    </select>                                                        
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>Materials/Handouts</td>
                                                    <td>                                                       
                                                        <select class="form-select @error('materials_handouts_rating') is-invalid @enderror" name="materials_handouts_rating" required>
                                                            <option value="">Choose</option>
                                                            <option value="Unsatisfactory">Unsatisfactory</option>
                                                            <option value="Poor">Poor</option>
                                                            <option value="Average">Average</option>
                                                            <option value="Good">Good</option>
                                                            <option value="Excellent">Excellent</option>
                                                        </select>                                                       
                                                    </td>
                                                </tr>
                                                
                                                <tr>
                                                    <td>Consultants/Resource Persons</td>
                                                    <td>                                                        
                                                        <select class="form-select @error('consultants_rating') is-invalid @enderror" name="consultants_rating" required>
                                                            <option value="">Choose</option>
                                                            <option value="Unsatisfactory">Unsatisfactory</option>
                                                            <option value="Poor">Poor</option>
                                                            <option value="Average">Average</option>
                                                            <option value="Good">Good</option>
                                                            <option value="Excellent">Excellent</option>
                                                        </select>
                                                        
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>Length of workshop</td>
                                                    <td>                                                        
                                                        <select class="form-select @error('workshop_length_rating') is-invalid @enderror" name="workshop_length_rating" required>
                                                            <option value="">Choose</option>
                                                            <option value="Unsatisfactory">Unsatisfactory</option>
                                                            <option value="Poor">Poor</option>
                                                            <option value="Average">Average</option>
                                                            <option value="Good">Good</option>
                                                            <option value="Excellent">Excellent</option>
                                                        </select>                                                       
                                                    </td>
                                                </tr>
                                                
                                                <tr>
                                                    <td>Logistical Arrangements</td>
                                                    <td>                                                        
                                                        <select class="form-select @error('logistical_arrangements_rating') is-invalid @enderror" name="logistical_arrangements_rating" required>
                                                            <option value="">Choose</option>
                                                            <option value="Unsatisfactory">Unsatisfactory</option>
                                                            <option value="Poor">Poor</option>
                                                            <option value="Average">Average</option>
                                                            <option value="Good">Good</option>
                                                            <option value="Excellent">Excellent</option>
                                                        </select>
                                                       
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>Venue</td>
                                                    <td>                                                       
                                                        <select class="form-select @error('venue_rating') is-invalid @enderror" name="venue_rating" required>
                                                            <option value="">Choose</option>
                                                            <option value="Unsatisfactory">Unsatisfactory</option>
                                                            <option value="Poor">Poor</option>
                                                            <option value="Average">Average</option>
                                                            <option value="Good">Good</option>
                                                            <option value="Excellent">Excellent</option>
                                                        </select>
                                                       
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>Lunches/Tea Breaks</td>
                                                    <td>                                                        
                                                        <select class="form-select @error('lunches_tea_breaks_rating') is-invalid @enderror" name="lunches_tea_breaks_rating" required>
                                                            <option value="">Choose</option>
                                                            <option value="Unsatisfactory">Unsatisfactory</option>
                                                            <option value="Poor">Poor</option>
                                                            <option value="Average">Average</option>
                                                            <option value="Good">Good</option>
                                                            <option value="Excellent">Excellent</option>
                                                        </select>                                                      
                                                    </td>
                                                </tr>
                                                
                                            </tbody>
                                        </table>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">8. Please give practical suggestions for how we could improve this workshop:</label>
                                        <textarea class="form-control @error('improvement_suggestions_workshop') is-invalid @enderror" name="improvement_suggestions_workshop" rows="3"></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">9. Other Comments:</label>
                                        <textarea class="form-control" name="other_comments" rows="3"></textarea>
                                    </div>
                                    
                                    <button type="submit" class="btn btn-primary">Submit Feedback</button>
                                </form>
                            </div>
                        </div>
                        
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
