<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Seminar Questions</title>

        <!-- Fonts -->
        <link href="https://fonts.bunny.net/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">

    <link href="{{ asset('vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
    <link  href="{{asset('vendor/datatables/jquery.dataTables.min.css')}}" rel="stylesheet">
    <link href="{{ asset('vendor/datatables/dataTables.bootstrap5.min.css') }}" rel="stylesheet">
    <link href="{{ asset('vendor/datatables/buttons.bootstrap5.min.css') }}" rel="stylesheet">
    <link href="{{ asset('vendor/datatables/dataTables.dateTime.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/css/style.css') }}" rel="stylesheet">
    <link rel="icon" href="{{ asset('assets/favicon2.png') }}" type="image/x-icon">
    <style>
        body {
          position: relative;
          background: url("/assets/background.jpg") center center no-repeat;
          background-size: cover;
        }
    
        body::before {
          content: "";
          position: fixed;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%;
          background-color: rgba(255, 255, 255, 0.6); /* Adjust opacity as needed */
          z-index: 1;
        }
        .content {
            position: relative;
            z-index: 2;
            }
            .img-responsive{
                width: 200px;
                height: 200px;
            }
        #delta{
            text-align: right;
        }
        main{
            margin-left: 400 !important;
        }
        
            @media (max-width: 576px) {
 
                .img-responsive{
                    width: 100px;
                    height: 100px;
                    justify-content: center;

                }
              #delta{
                text-align: center;
               
              }
              #galana{
                text-align: center;
              }
                
            }
      </style>
       
    </head>
    <body class="antialiased">
        <div class="background-image"></div>
        <div class="content">
         <!-- ======= Header ======= -->
            <header id="header" class="header fixed-top d-flex align-items-center">

                <div class="d-flex align-items-center justify-content-between">
                <a href="#" class="logo d-flex align-items-center">
                    <img src="{{ asset('assets/galanalogo.png') }}" alt="">
                    
                </a>
                
                </div><!-- End Logo -->

                <div class="search-bar">
                <form class="search-form d-flex align-items-center" method="POST" action="#">
                    <input type="text" name="query" placeholder="Search" title="Enter search keyword">
                    <button type="submit" title="Search"><i class="bi bi-search"></i></button>
                </form>
                </div><!-- End Search Bar -->

                <nav class="header-nav ms-auto">
                <ul class="d-flex align-items-center">

                    <li class="nav-item d-block d-lg-none">
                    <a class="nav-link nav-icon search-bar-toggle " href="#">
                        <i class="bi bi-search"></i>
                    </a>
                    </li><!-- End Search Icon-->

                

                </ul>
                </nav><!-- End Icons Navigation -->

            </header><!-- End Header -->
            <div class="container-fluid" id="landing-page">

            
                <div class="row" id="logos">
                    <div class="col-md-3" id="galana">
                        <img src="{{ asset('assets/galanalogo.png') }}" alt="" class="img-responsive" >
                    </div>
                    <div class="col-md-5">
                        <h3 style="text-align: center; font-weight: bold; padding-top: 50px;">Enhancing Change to Strengthen the Business</h3>
                    </div>
                    <div class="col-md-3" id="delta">
                        <img src="{{ asset('assets/deltalogo.png') }}" alt="" class="img-responsive" >
                    </div>
                </div>
            
           
            <div class="row">  
            @if (session('success'))
				<div class="alert alert-success" role="alert">
					{{ session('success') }}
				</div>
			@endif
        </div>
            <main id="main" class="main">              
                                                       
                  
                  <div class="row">
                    <div class="col-lg-7">
            
                      <div class="card">
                        <div class="card-body">
                            <h5 class="card-title" style="text-align: center">Registration Form</h5>
            
                            <!-- Vertical Form -->
                            <form class="row g-3" method="POST" action="{{ url('/users') }}">
                                    @csrf
                              <div class="col-12">
                                <label for="inputNanme4" class="form-label">Your Name</label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" id="inputNanme4">
                                @error('name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror 
                            </div>
                              <div class="col-12">
                                <label for="inputEmail4" class="form-label">Email</label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror" name="email" id="inputEmail4">
                                @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror   
                            </div>
                              
                              <div class="col-12">
                                <label for="inputAddress" class="form-label">Station</label>
                                <select class="form-control" id="station_id" name="station_id" required>
                                    <option value="">Select Station</option>
                                    @foreach ($stations as $station)
                                        <option value="{{ $station->id }}">{{ $station->name }}</option>
                                    @endforeach
                                    @error('station')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror 
                                </select>
                                
                              </div>
                              <div class="text-center">
                                <button type="submit" class="btn btn-primary">Next</button>
                              </div>
                            </form><!-- Vertical Form -->
            
                          </div>
                        </div>
                    </div>
                  </div>
              
            </main>
        </div>
        </div>
    </body>
</html>
