<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\QuestionsController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\RegisterController;
use App\Http\Controllers\LoginController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/admin', function(){
    return view('auth.login');
});

Route::get('/', [QuestionsController::class, 'user'])->name('enhance-change')->middleware('guest');
Route::get('register', [RegisterController::class, 'showRegistrationForm'])->name('register');
Route::post('register/create', [RegisterController::class, 'create'])->name('register.create');
Route::post('/users', [QuestionsController::class, 'storeUser']);
Route::get('/choose', [QuestionsController::class, 'choose'])->name('questions.choose');
Route::get('/questions', [QuestionsController::class, 'index'])->name('questions.index');
Route::get('/questions/create', [QuestionsController::class, 'create'])->name('questions.create');
Route::post('/questions', [QuestionsController::class, 'store']);

Route::get('feedback/create', [QuestionsController::class, 'createFeedback'])->name('feedback.create');
Route::post('/feedback', [QuestionsController::class, 'storeFeedback'])->name('feedback.store');
Auth::routes();
Route::middleware('auth')->group(function () {
    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    Route::get('/admin/questions', [AdminController::class, 'index']);
    Route::get('/live-polls', [AdminController::class, 'livePolls'])->name('admin.live-polls');
    Route::get('/questions/{question}/edit', [QuestionsController::class, 'edit'])->name('questions.edit');
    Route::put('/questions/{question}', [QuestionsController::class, 'update'])->name('questions.update');
    Route::delete('/questions/{question}', [QuestionsController::class, 'destroy'])->name('questions.destroy');

});



